<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AccessoryStorePurchase extends Model 
{

    protected $table = 'accessory_store_purchases';
    public $timestamps = true;
    protected $fillable = array('id', 'accessories_store_id', 'user_id', 'first_name', 'last_name', 'nickname', 'nationality', 'country_code', 'address', 'brand_id', 'car_model_id', 'home_delivery', 'is_mawater_card', 'price');

    public function accessoriesStore()
    {
        return $this->belongsTo('App\Models\AccessoriesStore');
    }

    public function accessories()
    {
        return $this->belongsToMany('App\Models\Accessory', 'accessory_store_purchase_accessories');
    }

}